package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppInstanceAdminResponse(
    appInstanceAdmin: Optional[zio.aws.chime.model.Identity] = Optional.Absent,
    appInstanceArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateAppInstanceAdminResponse = {
    import CreateAppInstanceAdminResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateAppInstanceAdminResponse
      .builder()
      .optionallyWith(appInstanceAdmin.map(value => value.buildAwsValue()))(
        _.appInstanceAdmin
      )
      .optionallyWith(
        appInstanceArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.appInstanceArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateAppInstanceAdminResponse.ReadOnly =
    zio.aws.chime.model.CreateAppInstanceAdminResponse.wrap(buildAwsValue())
}
object CreateAppInstanceAdminResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateAppInstanceAdminResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateAppInstanceAdminResponse =
      zio.aws.chime.model.CreateAppInstanceAdminResponse(
        appInstanceAdmin.map(value => value.asEditable),
        appInstanceArn.map(value => value)
      )
    def appInstanceAdmin: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def appInstanceArn: Optional[ChimeArn]
    def getAppInstanceAdmin
        : ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("appInstanceAdmin", appInstanceAdmin)
    def getAppInstanceArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceArn", appInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateAppInstanceAdminResponse
  ) extends zio.aws.chime.model.CreateAppInstanceAdminResponse.ReadOnly {
    override val appInstanceAdmin
        : Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appInstanceAdmin())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
    override val appInstanceArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateAppInstanceAdminResponse
  ): zio.aws.chime.model.CreateAppInstanceAdminResponse.ReadOnly = new Wrapper(
    impl
  )
}
