package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  ClientRequestToken,
  Metadata,
  NonEmptyResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppInstanceRequest(
    name: NonEmptyResourceName,
    metadata: Optional[Metadata] = Optional.Absent,
    clientRequestToken: ClientRequestToken,
    tags: Optional[Iterable[zio.aws.chime.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateAppInstanceRequest = {
    import CreateAppInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateAppInstanceRequest
      .builder()
      .name(NonEmptyResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateAppInstanceRequest.ReadOnly =
    zio.aws.chime.model.CreateAppInstanceRequest.wrap(buildAwsValue())
}
object CreateAppInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateAppInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateAppInstanceRequest =
      zio.aws.chime.model.CreateAppInstanceRequest(
        name,
        metadata.map(value => value),
        clientRequestToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: NonEmptyResourceName
    def metadata: Optional[Metadata]
    def clientRequestToken: ClientRequestToken
    def tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, NonEmptyResourceName] = ZIO.succeed(name)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.chime.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateAppInstanceRequest
  ) extends zio.aws.chime.model.CreateAppInstanceRequest.ReadOnly {
    override val name: NonEmptyResourceName =
      zio.aws.chime.model.primitives.NonEmptyResourceName(impl.name())
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chime.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateAppInstanceRequest
  ): zio.aws.chime.model.CreateAppInstanceRequest.ReadOnly = new Wrapper(impl)
}
