package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  ChimeArn,
  UserId,
  ClientRequestToken,
  UserName,
  Metadata
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppInstanceUserRequest(
    appInstanceArn: ChimeArn,
    appInstanceUserId: UserId,
    name: UserName,
    metadata: Optional[Metadata] = Optional.Absent,
    clientRequestToken: ClientRequestToken,
    tags: Optional[Iterable[zio.aws.chime.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateAppInstanceUserRequest = {
    import CreateAppInstanceUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateAppInstanceUserRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .appInstanceUserId(UserId.unwrap(appInstanceUserId): java.lang.String)
      .name(UserName.unwrap(name): java.lang.String)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateAppInstanceUserRequest.ReadOnly =
    zio.aws.chime.model.CreateAppInstanceUserRequest.wrap(buildAwsValue())
}
object CreateAppInstanceUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateAppInstanceUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateAppInstanceUserRequest =
      zio.aws.chime.model.CreateAppInstanceUserRequest(
        appInstanceArn,
        appInstanceUserId,
        name,
        metadata.map(value => value),
        clientRequestToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def appInstanceArn: ChimeArn
    def appInstanceUserId: UserId
    def name: UserName
    def metadata: Optional[Metadata]
    def clientRequestToken: ClientRequestToken
    def tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]]
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getAppInstanceUserId: ZIO[Any, Nothing, UserId] =
      ZIO.succeed(appInstanceUserId)
    def getName: ZIO[Any, Nothing, UserName] = ZIO.succeed(name)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.chime.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateAppInstanceUserRequest
  ) extends zio.aws.chime.model.CreateAppInstanceUserRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
    override val appInstanceUserId: UserId =
      zio.aws.chime.model.primitives.UserId(impl.appInstanceUserId())
    override val name: UserName =
      zio.aws.chime.model.primitives.UserName(impl.name())
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chime.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateAppInstanceUserRequest
  ): zio.aws.chime.model.CreateAppInstanceUserRequest.ReadOnly = new Wrapper(
    impl
  )
}
