package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAppInstanceUserResponse(
    appInstanceUserArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateAppInstanceUserResponse = {
    import CreateAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateAppInstanceUserResponse
      .builder()
      .optionallyWith(
        appInstanceUserArn.map(value =>
          ChimeArn.unwrap(value): java.lang.String
        )
      )(_.appInstanceUserArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateAppInstanceUserResponse.ReadOnly =
    zio.aws.chime.model.CreateAppInstanceUserResponse.wrap(buildAwsValue())
}
object CreateAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateAppInstanceUserResponse =
      zio.aws.chime.model
        .CreateAppInstanceUserResponse(appInstanceUserArn.map(value => value))
    def appInstanceUserArn: Optional[ChimeArn]
    def getAppInstanceUserArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceUserArn", appInstanceUserArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateAppInstanceUserResponse
  ) extends zio.aws.chime.model.CreateAppInstanceUserResponse.ReadOnly {
    override val appInstanceUserArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceUserArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateAppInstanceUserResponse
  ): zio.aws.chime.model.CreateAppInstanceUserResponse.ReadOnly = new Wrapper(
    impl
  )
}
