package zio.aws.chime.model
import zio.aws.chime.model.primitives.ExternalUserIdType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAttendeeError(
    externalUserId: Optional[ExternalUserIdType] = Optional.Absent,
    errorCode: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateAttendeeError = {
    import CreateAttendeeError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateAttendeeError
      .builder()
      .optionallyWith(
        externalUserId.map(value =>
          ExternalUserIdType.unwrap(value): java.lang.String
        )
      )(_.externalUserId)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateAttendeeError.ReadOnly =
    zio.aws.chime.model.CreateAttendeeError.wrap(buildAwsValue())
}
object CreateAttendeeError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateAttendeeError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateAttendeeError =
      zio.aws.chime.model.CreateAttendeeError(
        externalUserId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def externalUserId: Optional[ExternalUserIdType]
    def errorCode: Optional[String]
    def errorMessage: Optional[String]
    def getExternalUserId: ZIO[Any, AwsError, ExternalUserIdType] =
      AwsError.unwrapOptionField("externalUserId", externalUserId)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateAttendeeError
  ) extends zio.aws.chime.model.CreateAttendeeError.ReadOnly {
    override val externalUserId: Optional[ExternalUserIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalUserId())
        .map(value => zio.aws.chime.model.primitives.ExternalUserIdType(value))
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateAttendeeError
  ): zio.aws.chime.model.CreateAttendeeError.ReadOnly = new Wrapper(impl)
}
