package zio.aws.chime.model
import zio.aws.chime.model.primitives.{ExternalUserIdType, GuidString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAttendeeRequest(
    meetingId: GuidString,
    externalUserId: ExternalUserIdType,
    tags: Optional[Iterable[zio.aws.chime.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateAttendeeRequest = {
    import CreateAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .externalUserId(
        ExternalUserIdType.unwrap(externalUserId): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateAttendeeRequest.ReadOnly =
    zio.aws.chime.model.CreateAttendeeRequest.wrap(buildAwsValue())
}
object CreateAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateAttendeeRequest =
      zio.aws.chime.model.CreateAttendeeRequest(
        meetingId,
        externalUserId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def meetingId: GuidString
    def externalUserId: ExternalUserIdType
    def tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getExternalUserId: ZIO[Any, Nothing, ExternalUserIdType] =
      ZIO.succeed(externalUserId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.chime.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateAttendeeRequest
  ) extends zio.aws.chime.model.CreateAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val externalUserId: ExternalUserIdType =
      zio.aws.chime.model.primitives.ExternalUserIdType(impl.externalUserId())
    override val tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateAttendeeRequest
  ): zio.aws.chime.model.CreateAttendeeRequest.ReadOnly = new Wrapper(impl)
}
