package zio.aws.chime.model
import zio.aws.chime.model.primitives.ExternalUserIdType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAttendeeRequestItem(
    externalUserId: ExternalUserIdType,
    tags: Optional[Iterable[zio.aws.chime.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateAttendeeRequestItem = {
    import CreateAttendeeRequestItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateAttendeeRequestItem
      .builder()
      .externalUserId(
        ExternalUserIdType.unwrap(externalUserId): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateAttendeeRequestItem.ReadOnly =
    zio.aws.chime.model.CreateAttendeeRequestItem.wrap(buildAwsValue())
}
object CreateAttendeeRequestItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateAttendeeRequestItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateAttendeeRequestItem =
      zio.aws.chime.model.CreateAttendeeRequestItem(
        externalUserId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def externalUserId: ExternalUserIdType
    def tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]]
    def getExternalUserId: ZIO[Any, Nothing, ExternalUserIdType] =
      ZIO.succeed(externalUserId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.chime.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateAttendeeRequestItem
  ) extends zio.aws.chime.model.CreateAttendeeRequestItem.ReadOnly {
    override val externalUserId: ExternalUserIdType =
      zio.aws.chime.model.primitives.ExternalUserIdType(impl.externalUserId())
    override val tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateAttendeeRequestItem
  ): zio.aws.chime.model.CreateAttendeeRequestItem.ReadOnly = new Wrapper(impl)
}
