package zio.aws.chime.model
import zio.aws.chime.model.primitives.{SensitiveString, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBotRequest(
    accountId: NonEmptyString,
    displayName: SensitiveString,
    domain: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateBotRequest = {
    import CreateBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateBotRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .displayName(SensitiveString.unwrap(displayName): java.lang.String)
      .optionallyWith(
        domain.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateBotRequest.ReadOnly =
    zio.aws.chime.model.CreateBotRequest.wrap(buildAwsValue())
}
object CreateBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateBotRequest = zio.aws.chime.model
      .CreateBotRequest(accountId, displayName, domain.map(value => value))
    def accountId: NonEmptyString
    def displayName: SensitiveString
    def domain: Optional[NonEmptyString]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getDisplayName: ZIO[Any, Nothing, SensitiveString] =
      ZIO.succeed(displayName)
    def getDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateBotRequest
  ) extends zio.aws.chime.model.CreateBotRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val displayName: SensitiveString =
      zio.aws.chime.model.primitives.SensitiveString(impl.displayName())
    override val domain: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateBotRequest
  ): zio.aws.chime.model.CreateBotRequest.ReadOnly = new Wrapper(impl)
}
