package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateChannelBanResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    member: Optional[zio.aws.chime.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateChannelBanResponse = {
    import CreateChannelBanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateChannelBanResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateChannelBanResponse.ReadOnly =
    zio.aws.chime.model.CreateChannelBanResponse.wrap(buildAwsValue())
}
object CreateChannelBanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateChannelBanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateChannelBanResponse =
      zio.aws.chime.model.CreateChannelBanResponse(
        channelArn.map(value => value),
        member.map(value => value.asEditable)
      )
    def channelArn: Optional[ChimeArn]
    def member: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMember: ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateChannelBanResponse
  ) extends zio.aws.chime.model.CreateChannelBanResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val member: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateChannelBanResponse
  ): zio.aws.chime.model.CreateChannelBanResponse.ReadOnly = new Wrapper(impl)
}
