package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateChannelMembershipResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    member: Optional[zio.aws.chime.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateChannelMembershipResponse = {
    import CreateChannelMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateChannelMembershipResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateChannelMembershipResponse.ReadOnly =
    zio.aws.chime.model.CreateChannelMembershipResponse.wrap(buildAwsValue())
}
object CreateChannelMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateChannelMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateChannelMembershipResponse =
      zio.aws.chime.model.CreateChannelMembershipResponse(
        channelArn.map(value => value),
        member.map(value => value.asEditable)
      )
    def channelArn: Optional[ChimeArn]
    def member: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMember: ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateChannelMembershipResponse
  ) extends zio.aws.chime.model.CreateChannelMembershipResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val member: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateChannelMembershipResponse
  ): zio.aws.chime.model.CreateChannelMembershipResponse.ReadOnly = new Wrapper(
    impl
  )
}
