package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateChannelModeratorResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    channelModerator: Optional[zio.aws.chime.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateChannelModeratorResponse = {
    import CreateChannelModeratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateChannelModeratorResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(channelModerator.map(value => value.buildAwsValue()))(
        _.channelModerator
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateChannelModeratorResponse.ReadOnly =
    zio.aws.chime.model.CreateChannelModeratorResponse.wrap(buildAwsValue())
}
object CreateChannelModeratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateChannelModeratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateChannelModeratorResponse =
      zio.aws.chime.model.CreateChannelModeratorResponse(
        channelArn.map(value => value),
        channelModerator.map(value => value.asEditable)
      )
    def channelArn: Optional[ChimeArn]
    def channelModerator: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getChannelModerator
        : ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("channelModerator", channelModerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateChannelModeratorResponse
  ) extends zio.aws.chime.model.CreateChannelModeratorResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val channelModerator
        : Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelModerator())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateChannelModeratorResponse
  ): zio.aws.chime.model.CreateChannelModeratorResponse.ReadOnly = new Wrapper(
    impl
  )
}
