package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  ClientRequestToken,
  Metadata,
  NonEmptyResourceName,
  ChimeArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateChannelRequest(
    appInstanceArn: ChimeArn,
    name: NonEmptyResourceName,
    mode: Optional[zio.aws.chime.model.ChannelMode] = Optional.Absent,
    privacy: Optional[zio.aws.chime.model.ChannelPrivacy] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    clientRequestToken: ClientRequestToken,
    tags: Optional[Iterable[zio.aws.chime.model.Tag]] = Optional.Absent,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateChannelRequest = {
    import CreateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateChannelRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .name(NonEmptyResourceName.unwrap(name): java.lang.String)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateChannelRequest.ReadOnly =
    zio.aws.chime.model.CreateChannelRequest.wrap(buildAwsValue())
}
object CreateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateChannelRequest =
      zio.aws.chime.model.CreateChannelRequest(
        appInstanceArn,
        name,
        mode.map(value => value),
        privacy.map(value => value),
        metadata.map(value => value),
        clientRequestToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        chimeBearer.map(value => value)
      )
    def appInstanceArn: ChimeArn
    def name: NonEmptyResourceName
    def mode: Optional[zio.aws.chime.model.ChannelMode]
    def privacy: Optional[zio.aws.chime.model.ChannelPrivacy]
    def metadata: Optional[Metadata]
    def clientRequestToken: ClientRequestToken
    def tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]]
    def chimeBearer: Optional[ChimeArn]
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getName: ZIO[Any, Nothing, NonEmptyResourceName] = ZIO.succeed(name)
    def getMode: ZIO[Any, AwsError, zio.aws.chime.model.ChannelMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getPrivacy: ZIO[Any, AwsError, zio.aws.chime.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.chime.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateChannelRequest
  ) extends zio.aws.chime.model.CreateChannelRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
    override val name: NonEmptyResourceName =
      zio.aws.chime.model.primitives.NonEmptyResourceName(impl.name())
    override val mode: Optional[zio.aws.chime.model.ChannelMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.chime.model.ChannelMode.wrap(value))
    override val privacy: Optional[zio.aws.chime.model.ChannelPrivacy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privacy())
        .map(value => zio.aws.chime.model.ChannelPrivacy.wrap(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chime.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Tag.wrap(item)
          }.toList
        )
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateChannelRequest
  ): zio.aws.chime.model.CreateChannelRequest.ReadOnly = new Wrapper(impl)
}
