package zio.aws.chime.model
import zio.aws.chime.model.primitives.{ClientRequestToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMediaCapturePipelineRequest(
    sourceType: zio.aws.chime.model.MediaPipelineSourceType,
    sourceArn: Arn,
    sinkType: zio.aws.chime.model.MediaPipelineSinkType,
    sinkArn: Arn,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    chimeSdkMeetingConfiguration: Optional[
      zio.aws.chime.model.ChimeSdkMeetingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineRequest = {
    import CreateMediaCapturePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineRequest
      .builder()
      .sourceType(sourceType.unwrap)
      .sourceArn(Arn.unwrap(sourceArn): java.lang.String)
      .sinkType(sinkType.unwrap)
      .sinkArn(Arn.unwrap(sinkArn): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        chimeSdkMeetingConfiguration.map(value => value.buildAwsValue())
      )(_.chimeSdkMeetingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.CreateMediaCapturePipelineRequest.ReadOnly =
    zio.aws.chime.model.CreateMediaCapturePipelineRequest.wrap(buildAwsValue())
}
object CreateMediaCapturePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateMediaCapturePipelineRequest =
      zio.aws.chime.model.CreateMediaCapturePipelineRequest(
        sourceType,
        sourceArn,
        sinkType,
        sinkArn,
        clientRequestToken.map(value => value),
        chimeSdkMeetingConfiguration.map(value => value.asEditable)
      )
    def sourceType: zio.aws.chime.model.MediaPipelineSourceType
    def sourceArn: Arn
    def sinkType: zio.aws.chime.model.MediaPipelineSinkType
    def sinkArn: Arn
    def clientRequestToken: Optional[ClientRequestToken]
    def chimeSdkMeetingConfiguration
        : Optional[zio.aws.chime.model.ChimeSdkMeetingConfiguration.ReadOnly]
    def getSourceType
        : ZIO[Any, Nothing, zio.aws.chime.model.MediaPipelineSourceType] =
      ZIO.succeed(sourceType)
    def getSourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(sourceArn)
    def getSinkType
        : ZIO[Any, Nothing, zio.aws.chime.model.MediaPipelineSinkType] =
      ZIO.succeed(sinkType)
    def getSinkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(sinkArn)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getChimeSdkMeetingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.ChimeSdkMeetingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "chimeSdkMeetingConfiguration",
      chimeSdkMeetingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineRequest
  ) extends zio.aws.chime.model.CreateMediaCapturePipelineRequest.ReadOnly {
    override val sourceType: zio.aws.chime.model.MediaPipelineSourceType =
      zio.aws.chime.model.MediaPipelineSourceType.wrap(impl.sourceType())
    override val sourceArn: Arn =
      zio.aws.chime.model.primitives.Arn(impl.sourceArn())
    override val sinkType: zio.aws.chime.model.MediaPipelineSinkType =
      zio.aws.chime.model.MediaPipelineSinkType.wrap(impl.sinkType())
    override val sinkArn: Arn =
      zio.aws.chime.model.primitives.Arn(impl.sinkArn())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.chime.model.primitives.ClientRequestToken(value))
    override val chimeSdkMeetingConfiguration
        : Optional[zio.aws.chime.model.ChimeSdkMeetingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.chimeSdkMeetingConfiguration())
        .map(value =>
          zio.aws.chime.model.ChimeSdkMeetingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineRequest
  ): zio.aws.chime.model.CreateMediaCapturePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
