package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMediaCapturePipelineResponse(
    mediaCapturePipeline: Optional[zio.aws.chime.model.MediaCapturePipeline] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineResponse = {
    import CreateMediaCapturePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineResponse
      .builder()
      .optionallyWith(mediaCapturePipeline.map(value => value.buildAwsValue()))(
        _.mediaCapturePipeline
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.CreateMediaCapturePipelineResponse.ReadOnly =
    zio.aws.chime.model.CreateMediaCapturePipelineResponse.wrap(buildAwsValue())
}
object CreateMediaCapturePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateMediaCapturePipelineResponse =
      zio.aws.chime.model.CreateMediaCapturePipelineResponse(
        mediaCapturePipeline.map(value => value.asEditable)
      )
    def mediaCapturePipeline
        : Optional[zio.aws.chime.model.MediaCapturePipeline.ReadOnly]
    def getMediaCapturePipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.MediaCapturePipeline.ReadOnly
    ] = AwsError.unwrapOptionField("mediaCapturePipeline", mediaCapturePipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineResponse
  ) extends zio.aws.chime.model.CreateMediaCapturePipelineResponse.ReadOnly {
    override val mediaCapturePipeline
        : Optional[zio.aws.chime.model.MediaCapturePipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaCapturePipeline())
        .map(value => zio.aws.chime.model.MediaCapturePipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateMediaCapturePipelineResponse
  ): zio.aws.chime.model.CreateMediaCapturePipelineResponse.ReadOnly =
    new Wrapper(impl)
}
