package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  JoinTokenString,
  E164PhoneNumber,
  GuidString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateMeetingDialOutRequest(
    meetingId: GuidString,
    fromPhoneNumber: E164PhoneNumber,
    toPhoneNumber: E164PhoneNumber,
    joinToken: JoinTokenString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateMeetingDialOutRequest = {
    import CreateMeetingDialOutRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateMeetingDialOutRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .fromPhoneNumber(
        E164PhoneNumber.unwrap(fromPhoneNumber): java.lang.String
      )
      .toPhoneNumber(E164PhoneNumber.unwrap(toPhoneNumber): java.lang.String)
      .joinToken(JoinTokenString.unwrap(joinToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateMeetingDialOutRequest.ReadOnly =
    zio.aws.chime.model.CreateMeetingDialOutRequest.wrap(buildAwsValue())
}
object CreateMeetingDialOutRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateMeetingDialOutRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateMeetingDialOutRequest =
      zio.aws.chime.model.CreateMeetingDialOutRequest(
        meetingId,
        fromPhoneNumber,
        toPhoneNumber,
        joinToken
      )
    def meetingId: GuidString
    def fromPhoneNumber: E164PhoneNumber
    def toPhoneNumber: E164PhoneNumber
    def joinToken: JoinTokenString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getFromPhoneNumber: ZIO[Any, Nothing, E164PhoneNumber] =
      ZIO.succeed(fromPhoneNumber)
    def getToPhoneNumber: ZIO[Any, Nothing, E164PhoneNumber] =
      ZIO.succeed(toPhoneNumber)
    def getJoinToken: ZIO[Any, Nothing, JoinTokenString] =
      ZIO.succeed(joinToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingDialOutRequest
  ) extends zio.aws.chime.model.CreateMeetingDialOutRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val fromPhoneNumber: E164PhoneNumber =
      zio.aws.chime.model.primitives.E164PhoneNumber(impl.fromPhoneNumber())
    override val toPhoneNumber: E164PhoneNumber =
      zio.aws.chime.model.primitives.E164PhoneNumber(impl.toPhoneNumber())
    override val joinToken: JoinTokenString =
      zio.aws.chime.model.primitives.JoinTokenString(impl.joinToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingDialOutRequest
  ): zio.aws.chime.model.CreateMeetingDialOutRequest.ReadOnly = new Wrapper(
    impl
  )
}
