package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMeetingDialOutResponse(
    transactionId: Optional[GuidString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateMeetingDialOutResponse = {
    import CreateMeetingDialOutResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateMeetingDialOutResponse
      .builder()
      .optionallyWith(
        transactionId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateMeetingDialOutResponse.ReadOnly =
    zio.aws.chime.model.CreateMeetingDialOutResponse.wrap(buildAwsValue())
}
object CreateMeetingDialOutResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateMeetingDialOutResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateMeetingDialOutResponse =
      zio.aws.chime.model
        .CreateMeetingDialOutResponse(transactionId.map(value => value))
    def transactionId: Optional[GuidString]
    def getTransactionId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingDialOutResponse
  ) extends zio.aws.chime.model.CreateMeetingDialOutResponse.ReadOnly {
    override val transactionId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.transactionId())
      .map(value => zio.aws.chime.model.primitives.GuidString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingDialOutResponse
  ): zio.aws.chime.model.CreateMeetingDialOutResponse.ReadOnly = new Wrapper(
    impl
  )
}
