package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  ExternalUserIdType,
  ExternalMeetingIdType,
  ClientRequestToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMeetingRequest(
    clientRequestToken: ClientRequestToken,
    externalMeetingId: Optional[ExternalMeetingIdType] = Optional.Absent,
    meetingHostId: Optional[ExternalUserIdType] = Optional.Absent,
    mediaRegion: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.chime.model.Tag]] = Optional.Absent,
    notificationsConfiguration: Optional[
      zio.aws.chime.model.MeetingNotificationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateMeetingRequest = {
    import CreateMeetingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateMeetingRequest
      .builder()
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        externalMeetingId.map(value =>
          ExternalMeetingIdType.unwrap(value): java.lang.String
        )
      )(_.externalMeetingId)
      .optionallyWith(
        meetingHostId.map(value =>
          ExternalUserIdType.unwrap(value): java.lang.String
        )
      )(_.meetingHostId)
      .optionallyWith(mediaRegion.map(value => value: java.lang.String))(
        _.mediaRegion
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        notificationsConfiguration.map(value => value.buildAwsValue())
      )(_.notificationsConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateMeetingRequest.ReadOnly =
    zio.aws.chime.model.CreateMeetingRequest.wrap(buildAwsValue())
}
object CreateMeetingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateMeetingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateMeetingRequest =
      zio.aws.chime.model.CreateMeetingRequest(
        clientRequestToken,
        externalMeetingId.map(value => value),
        meetingHostId.map(value => value),
        mediaRegion.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notificationsConfiguration.map(value => value.asEditable)
      )
    def clientRequestToken: ClientRequestToken
    def externalMeetingId: Optional[ExternalMeetingIdType]
    def meetingHostId: Optional[ExternalUserIdType]
    def mediaRegion: Optional[String]
    def tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]]
    def notificationsConfiguration: Optional[
      zio.aws.chime.model.MeetingNotificationConfiguration.ReadOnly
    ]
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getExternalMeetingId: ZIO[Any, AwsError, ExternalMeetingIdType] =
      AwsError.unwrapOptionField("externalMeetingId", externalMeetingId)
    def getMeetingHostId: ZIO[Any, AwsError, ExternalUserIdType] =
      AwsError.unwrapOptionField("meetingHostId", meetingHostId)
    def getMediaRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mediaRegion", mediaRegion)
    def getTags: ZIO[Any, AwsError, List[zio.aws.chime.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNotificationsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.MeetingNotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationsConfiguration",
      notificationsConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingRequest
  ) extends zio.aws.chime.model.CreateMeetingRequest.ReadOnly {
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chime.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val externalMeetingId: Optional[ExternalMeetingIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalMeetingId())
        .map(value =>
          zio.aws.chime.model.primitives.ExternalMeetingIdType(value)
        )
    override val meetingHostId: Optional[ExternalUserIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.meetingHostId())
        .map(value => zio.aws.chime.model.primitives.ExternalUserIdType(value))
    override val mediaRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaRegion())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Tag.wrap(item)
          }.toList
        )
    override val notificationsConfiguration: Optional[
      zio.aws.chime.model.MeetingNotificationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationsConfiguration())
      .map(value =>
        zio.aws.chime.model.MeetingNotificationConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingRequest
  ): zio.aws.chime.model.CreateMeetingRequest.ReadOnly = new Wrapper(impl)
}
