package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMeetingResponse(
    meeting: Optional[zio.aws.chime.model.Meeting] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateMeetingResponse = {
    import CreateMeetingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateMeetingResponse
      .builder()
      .optionallyWith(meeting.map(value => value.buildAwsValue()))(_.meeting)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateMeetingResponse.ReadOnly =
    zio.aws.chime.model.CreateMeetingResponse.wrap(buildAwsValue())
}
object CreateMeetingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateMeetingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateMeetingResponse =
      zio.aws.chime.model
        .CreateMeetingResponse(meeting.map(value => value.asEditable))
    def meeting: Optional[zio.aws.chime.model.Meeting.ReadOnly]
    def getMeeting: ZIO[Any, AwsError, zio.aws.chime.model.Meeting.ReadOnly] =
      AwsError.unwrapOptionField("meeting", meeting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingResponse
  ) extends zio.aws.chime.model.CreateMeetingResponse.ReadOnly {
    override val meeting: Optional[zio.aws.chime.model.Meeting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.meeting())
        .map(value => zio.aws.chime.model.Meeting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingResponse
  ): zio.aws.chime.model.CreateMeetingResponse.ReadOnly = new Wrapper(impl)
}
