package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  ExternalUserIdType,
  ExternalMeetingIdType,
  ClientRequestToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMeetingWithAttendeesRequest(
    clientRequestToken: ClientRequestToken,
    externalMeetingId: Optional[ExternalMeetingIdType] = Optional.Absent,
    meetingHostId: Optional[ExternalUserIdType] = Optional.Absent,
    mediaRegion: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.chime.model.Tag]] = Optional.Absent,
    notificationsConfiguration: Optional[
      zio.aws.chime.model.MeetingNotificationConfiguration
    ] = Optional.Absent,
    attendees: Optional[
      Iterable[zio.aws.chime.model.CreateAttendeeRequestItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesRequest = {
    import CreateMeetingWithAttendeesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesRequest
      .builder()
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .optionallyWith(
        externalMeetingId.map(value =>
          ExternalMeetingIdType.unwrap(value): java.lang.String
        )
      )(_.externalMeetingId)
      .optionallyWith(
        meetingHostId.map(value =>
          ExternalUserIdType.unwrap(value): java.lang.String
        )
      )(_.meetingHostId)
      .optionallyWith(mediaRegion.map(value => value: java.lang.String))(
        _.mediaRegion
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        notificationsConfiguration.map(value => value.buildAwsValue())
      )(_.notificationsConfiguration)
      .optionallyWith(
        attendees.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attendees)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.CreateMeetingWithAttendeesRequest.ReadOnly =
    zio.aws.chime.model.CreateMeetingWithAttendeesRequest.wrap(buildAwsValue())
}
object CreateMeetingWithAttendeesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateMeetingWithAttendeesRequest =
      zio.aws.chime.model.CreateMeetingWithAttendeesRequest(
        clientRequestToken,
        externalMeetingId.map(value => value),
        meetingHostId.map(value => value),
        mediaRegion.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notificationsConfiguration.map(value => value.asEditable),
        attendees.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientRequestToken: ClientRequestToken
    def externalMeetingId: Optional[ExternalMeetingIdType]
    def meetingHostId: Optional[ExternalUserIdType]
    def mediaRegion: Optional[String]
    def tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]]
    def notificationsConfiguration: Optional[
      zio.aws.chime.model.MeetingNotificationConfiguration.ReadOnly
    ]
    def attendees
        : Optional[List[zio.aws.chime.model.CreateAttendeeRequestItem.ReadOnly]]
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getExternalMeetingId: ZIO[Any, AwsError, ExternalMeetingIdType] =
      AwsError.unwrapOptionField("externalMeetingId", externalMeetingId)
    def getMeetingHostId: ZIO[Any, AwsError, ExternalUserIdType] =
      AwsError.unwrapOptionField("meetingHostId", meetingHostId)
    def getMediaRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mediaRegion", mediaRegion)
    def getTags: ZIO[Any, AwsError, List[zio.aws.chime.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNotificationsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.MeetingNotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationsConfiguration",
      notificationsConfiguration
    )
    def getAttendees: ZIO[Any, AwsError, List[
      zio.aws.chime.model.CreateAttendeeRequestItem.ReadOnly
    ]] = AwsError.unwrapOptionField("attendees", attendees)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesRequest
  ) extends zio.aws.chime.model.CreateMeetingWithAttendeesRequest.ReadOnly {
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chime.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val externalMeetingId: Optional[ExternalMeetingIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalMeetingId())
        .map(value =>
          zio.aws.chime.model.primitives.ExternalMeetingIdType(value)
        )
    override val meetingHostId: Optional[ExternalUserIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.meetingHostId())
        .map(value => zio.aws.chime.model.primitives.ExternalUserIdType(value))
    override val mediaRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaRegion())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.chime.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Tag.wrap(item)
          }.toList
        )
    override val notificationsConfiguration: Optional[
      zio.aws.chime.model.MeetingNotificationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationsConfiguration())
      .map(value =>
        zio.aws.chime.model.MeetingNotificationConfiguration.wrap(value)
      )
    override val attendees: Optional[
      List[zio.aws.chime.model.CreateAttendeeRequestItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attendees())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.CreateAttendeeRequestItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesRequest
  ): zio.aws.chime.model.CreateMeetingWithAttendeesRequest.ReadOnly =
    new Wrapper(impl)
}
