package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMeetingWithAttendeesResponse(
    meeting: Optional[zio.aws.chime.model.Meeting] = Optional.Absent,
    attendees: Optional[Iterable[zio.aws.chime.model.Attendee]] =
      Optional.Absent,
    errors: Optional[Iterable[zio.aws.chime.model.CreateAttendeeError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesResponse = {
    import CreateMeetingWithAttendeesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesResponse
      .builder()
      .optionallyWith(meeting.map(value => value.buildAwsValue()))(_.meeting)
      .optionallyWith(
        attendees.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attendees)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.CreateMeetingWithAttendeesResponse.ReadOnly =
    zio.aws.chime.model.CreateMeetingWithAttendeesResponse.wrap(buildAwsValue())
}
object CreateMeetingWithAttendeesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateMeetingWithAttendeesResponse =
      zio.aws.chime.model.CreateMeetingWithAttendeesResponse(
        meeting.map(value => value.asEditable),
        attendees.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def meeting: Optional[zio.aws.chime.model.Meeting.ReadOnly]
    def attendees: Optional[List[zio.aws.chime.model.Attendee.ReadOnly]]
    def errors: Optional[List[zio.aws.chime.model.CreateAttendeeError.ReadOnly]]
    def getMeeting: ZIO[Any, AwsError, zio.aws.chime.model.Meeting.ReadOnly] =
      AwsError.unwrapOptionField("meeting", meeting)
    def getAttendees
        : ZIO[Any, AwsError, List[zio.aws.chime.model.Attendee.ReadOnly]] =
      AwsError.unwrapOptionField("attendees", attendees)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.chime.model.CreateAttendeeError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesResponse
  ) extends zio.aws.chime.model.CreateMeetingWithAttendeesResponse.ReadOnly {
    override val meeting: Optional[zio.aws.chime.model.Meeting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.meeting())
        .map(value => zio.aws.chime.model.Meeting.wrap(value))
    override val attendees
        : Optional[List[zio.aws.chime.model.Attendee.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attendees())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.Attendee.wrap(item)
          }.toList
        )
    override val errors
        : Optional[List[zio.aws.chime.model.CreateAttendeeError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.CreateAttendeeError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateMeetingWithAttendeesResponse
  ): zio.aws.chime.model.CreateMeetingWithAttendeesResponse.ReadOnly =
    new Wrapper(impl)
}
