package zio.aws.chime.model
import zio.aws.chime.model.primitives.E164PhoneNumber
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreatePhoneNumberOrderRequest(
    productType: zio.aws.chime.model.PhoneNumberProductType,
    e164PhoneNumbers: Iterable[E164PhoneNumber]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderRequest = {
    import CreatePhoneNumberOrderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderRequest
      .builder()
      .productType(productType.unwrap)
      .e164PhoneNumbers(e164PhoneNumbers.map { item =>
        E164PhoneNumber.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreatePhoneNumberOrderRequest.ReadOnly =
    zio.aws.chime.model.CreatePhoneNumberOrderRequest.wrap(buildAwsValue())
}
object CreatePhoneNumberOrderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreatePhoneNumberOrderRequest =
      zio.aws.chime.model
        .CreatePhoneNumberOrderRequest(productType, e164PhoneNumbers)
    def productType: zio.aws.chime.model.PhoneNumberProductType
    def e164PhoneNumbers: List[E164PhoneNumber]
    def getProductType
        : ZIO[Any, Nothing, zio.aws.chime.model.PhoneNumberProductType] =
      ZIO.succeed(productType)
    def getE164PhoneNumbers: ZIO[Any, Nothing, List[E164PhoneNumber]] =
      ZIO.succeed(e164PhoneNumbers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderRequest
  ) extends zio.aws.chime.model.CreatePhoneNumberOrderRequest.ReadOnly {
    override val productType: zio.aws.chime.model.PhoneNumberProductType =
      zio.aws.chime.model.PhoneNumberProductType.wrap(impl.productType())
    override val e164PhoneNumbers: List[E164PhoneNumber] = impl
      .e164PhoneNumbers()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.E164PhoneNumber(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderRequest
  ): zio.aws.chime.model.CreatePhoneNumberOrderRequest.ReadOnly = new Wrapper(
    impl
  )
}
