package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePhoneNumberOrderResponse(
    phoneNumberOrder: Optional[zio.aws.chime.model.PhoneNumberOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderResponse = {
    import CreatePhoneNumberOrderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderResponse
      .builder()
      .optionallyWith(phoneNumberOrder.map(value => value.buildAwsValue()))(
        _.phoneNumberOrder
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreatePhoneNumberOrderResponse.ReadOnly =
    zio.aws.chime.model.CreatePhoneNumberOrderResponse.wrap(buildAwsValue())
}
object CreatePhoneNumberOrderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreatePhoneNumberOrderResponse =
      zio.aws.chime.model.CreatePhoneNumberOrderResponse(
        phoneNumberOrder.map(value => value.asEditable)
      )
    def phoneNumberOrder
        : Optional[zio.aws.chime.model.PhoneNumberOrder.ReadOnly]
    def getPhoneNumberOrder
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberOrder.ReadOnly] =
      AwsError.unwrapOptionField("phoneNumberOrder", phoneNumberOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderResponse
  ) extends zio.aws.chime.model.CreatePhoneNumberOrderResponse.ReadOnly {
    override val phoneNumberOrder
        : Optional[zio.aws.chime.model.PhoneNumberOrder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberOrder())
        .map(value => zio.aws.chime.model.PhoneNumberOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreatePhoneNumberOrderResponse
  ): zio.aws.chime.model.CreatePhoneNumberOrderResponse.ReadOnly = new Wrapper(
    impl
  )
}
