package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRoomMembershipRequest(
    accountId: NonEmptyString,
    roomId: NonEmptyString,
    memberId: NonEmptyString,
    role: Optional[zio.aws.chime.model.RoomMembershipRole] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateRoomMembershipRequest = {
    import CreateRoomMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateRoomMembershipRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .roomId(NonEmptyString.unwrap(roomId): java.lang.String)
      .memberId(NonEmptyString.unwrap(memberId): java.lang.String)
      .optionallyWith(role.map(value => value.unwrap))(_.role)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateRoomMembershipRequest.ReadOnly =
    zio.aws.chime.model.CreateRoomMembershipRequest.wrap(buildAwsValue())
}
object CreateRoomMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateRoomMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateRoomMembershipRequest =
      zio.aws.chime.model.CreateRoomMembershipRequest(
        accountId,
        roomId,
        memberId,
        role.map(value => value)
      )
    def accountId: NonEmptyString
    def roomId: NonEmptyString
    def memberId: NonEmptyString
    def role: Optional[zio.aws.chime.model.RoomMembershipRole]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getRoomId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(roomId)
    def getMemberId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(memberId)
    def getRole: ZIO[Any, AwsError, zio.aws.chime.model.RoomMembershipRole] =
      AwsError.unwrapOptionField("role", role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateRoomMembershipRequest
  ) extends zio.aws.chime.model.CreateRoomMembershipRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val roomId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.roomId())
    override val memberId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.memberId())
    override val role: Optional[zio.aws.chime.model.RoomMembershipRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.role())
        .map(value => zio.aws.chime.model.RoomMembershipRole.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateRoomMembershipRequest
  ): zio.aws.chime.model.CreateRoomMembershipRequest.ReadOnly = new Wrapper(
    impl
  )
}
