package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRoomMembershipResponse(
    roomMembership: Optional[zio.aws.chime.model.RoomMembership] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateRoomMembershipResponse = {
    import CreateRoomMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateRoomMembershipResponse
      .builder()
      .optionallyWith(roomMembership.map(value => value.buildAwsValue()))(
        _.roomMembership
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateRoomMembershipResponse.ReadOnly =
    zio.aws.chime.model.CreateRoomMembershipResponse.wrap(buildAwsValue())
}
object CreateRoomMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateRoomMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateRoomMembershipResponse =
      zio.aws.chime.model.CreateRoomMembershipResponse(
        roomMembership.map(value => value.asEditable)
      )
    def roomMembership: Optional[zio.aws.chime.model.RoomMembership.ReadOnly]
    def getRoomMembership
        : ZIO[Any, AwsError, zio.aws.chime.model.RoomMembership.ReadOnly] =
      AwsError.unwrapOptionField("roomMembership", roomMembership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateRoomMembershipResponse
  ) extends zio.aws.chime.model.CreateRoomMembershipResponse.ReadOnly {
    override val roomMembership
        : Optional[zio.aws.chime.model.RoomMembership.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roomMembership())
        .map(value => zio.aws.chime.model.RoomMembership.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateRoomMembershipResponse
  ): zio.aws.chime.model.CreateRoomMembershipResponse.ReadOnly = new Wrapper(
    impl
  )
}
