package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  ClientRequestToken,
  SensitiveString,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRoomRequest(
    accountId: NonEmptyString,
    name: SensitiveString,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateRoomRequest = {
    import CreateRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateRoomRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .name(SensitiveString.unwrap(name): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateRoomRequest.ReadOnly =
    zio.aws.chime.model.CreateRoomRequest.wrap(buildAwsValue())
}
object CreateRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateRoomRequest =
      zio.aws.chime.model.CreateRoomRequest(
        accountId,
        name,
        clientRequestToken.map(value => value)
      )
    def accountId: NonEmptyString
    def name: SensitiveString
    def clientRequestToken: Optional[ClientRequestToken]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, SensitiveString] = ZIO.succeed(name)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateRoomRequest
  ) extends zio.aws.chime.model.CreateRoomRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val name: SensitiveString =
      zio.aws.chime.model.primitives.SensitiveString(impl.name())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.chime.model.primitives.ClientRequestToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateRoomRequest
  ): zio.aws.chime.model.CreateRoomRequest.ReadOnly = new Wrapper(impl)
}
