package zio.aws.chime.model
import zio.aws.chime.model.primitives.SipMediaApplicationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateSipMediaApplicationRequest(
    awsRegion: String,
    name: SipMediaApplicationName,
    endpoints: Iterable[zio.aws.chime.model.SipMediaApplicationEndpoint]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationRequest = {
    import CreateSipMediaApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationRequest
      .builder()
      .awsRegion(awsRegion: java.lang.String)
      .name(SipMediaApplicationName.unwrap(name): java.lang.String)
      .endpoints(endpoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.CreateSipMediaApplicationRequest.ReadOnly =
    zio.aws.chime.model.CreateSipMediaApplicationRequest.wrap(buildAwsValue())
}
object CreateSipMediaApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateSipMediaApplicationRequest =
      zio.aws.chime.model.CreateSipMediaApplicationRequest(
        awsRegion,
        name,
        endpoints.map { item =>
          item.asEditable
        }
      )
    def awsRegion: String
    def name: SipMediaApplicationName
    def endpoints
        : List[zio.aws.chime.model.SipMediaApplicationEndpoint.ReadOnly]
    def getAwsRegion: ZIO[Any, Nothing, String] = ZIO.succeed(awsRegion)
    def getName: ZIO[Any, Nothing, SipMediaApplicationName] = ZIO.succeed(name)
    def getEndpoints: ZIO[Any, Nothing, List[
      zio.aws.chime.model.SipMediaApplicationEndpoint.ReadOnly
    ]] = ZIO.succeed(endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationRequest
  ) extends zio.aws.chime.model.CreateSipMediaApplicationRequest.ReadOnly {
    override val awsRegion: String = impl.awsRegion(): String
    override val name: SipMediaApplicationName =
      zio.aws.chime.model.primitives.SipMediaApplicationName(impl.name())
    override val endpoints
        : List[zio.aws.chime.model.SipMediaApplicationEndpoint.ReadOnly] = impl
      .endpoints()
      .asScala
      .map { item =>
        zio.aws.chime.model.SipMediaApplicationEndpoint.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationRequest
  ): zio.aws.chime.model.CreateSipMediaApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
