package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSipMediaApplicationResponse(
    sipMediaApplication: Optional[zio.aws.chime.model.SipMediaApplication] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationResponse = {
    import CreateSipMediaApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationResponse
      .builder()
      .optionallyWith(sipMediaApplication.map(value => value.buildAwsValue()))(
        _.sipMediaApplication
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.CreateSipMediaApplicationResponse.ReadOnly =
    zio.aws.chime.model.CreateSipMediaApplicationResponse.wrap(buildAwsValue())
}
object CreateSipMediaApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateSipMediaApplicationResponse =
      zio.aws.chime.model.CreateSipMediaApplicationResponse(
        sipMediaApplication.map(value => value.asEditable)
      )
    def sipMediaApplication
        : Optional[zio.aws.chime.model.SipMediaApplication.ReadOnly]
    def getSipMediaApplication
        : ZIO[Any, AwsError, zio.aws.chime.model.SipMediaApplication.ReadOnly] =
      AwsError.unwrapOptionField("sipMediaApplication", sipMediaApplication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationResponse
  ) extends zio.aws.chime.model.CreateSipMediaApplicationResponse.ReadOnly {
    override val sipMediaApplication
        : Optional[zio.aws.chime.model.SipMediaApplication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplication())
        .map(value => zio.aws.chime.model.SipMediaApplication.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateSipMediaApplicationResponse
  ): zio.aws.chime.model.CreateSipMediaApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
