package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  NullableBoolean,
  NonEmptyString,
  SipRuleName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSipRuleRequest(
    name: SipRuleName,
    triggerType: zio.aws.chime.model.SipRuleTriggerType,
    triggerValue: NonEmptyString,
    disabled: Optional[NullableBoolean] = Optional.Absent,
    targetApplications: Iterable[zio.aws.chime.model.SipRuleTargetApplication]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateSipRuleRequest = {
    import CreateSipRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateSipRuleRequest
      .builder()
      .name(SipRuleName.unwrap(name): java.lang.String)
      .triggerType(triggerType.unwrap)
      .triggerValue(NonEmptyString.unwrap(triggerValue): java.lang.String)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .targetApplications(targetApplications.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateSipRuleRequest.ReadOnly =
    zio.aws.chime.model.CreateSipRuleRequest.wrap(buildAwsValue())
}
object CreateSipRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateSipRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateSipRuleRequest =
      zio.aws.chime.model.CreateSipRuleRequest(
        name,
        triggerType,
        triggerValue,
        disabled.map(value => value),
        targetApplications.map { item =>
          item.asEditable
        }
      )
    def name: SipRuleName
    def triggerType: zio.aws.chime.model.SipRuleTriggerType
    def triggerValue: NonEmptyString
    def disabled: Optional[NullableBoolean]
    def targetApplications
        : List[zio.aws.chime.model.SipRuleTargetApplication.ReadOnly]
    def getName: ZIO[Any, Nothing, SipRuleName] = ZIO.succeed(name)
    def getTriggerType
        : ZIO[Any, Nothing, zio.aws.chime.model.SipRuleTriggerType] =
      ZIO.succeed(triggerType)
    def getTriggerValue: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(triggerValue)
    def getDisabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getTargetApplications: ZIO[Any, Nothing, List[
      zio.aws.chime.model.SipRuleTargetApplication.ReadOnly
    ]] = ZIO.succeed(targetApplications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateSipRuleRequest
  ) extends zio.aws.chime.model.CreateSipRuleRequest.ReadOnly {
    override val name: SipRuleName =
      zio.aws.chime.model.primitives.SipRuleName(impl.name())
    override val triggerType: zio.aws.chime.model.SipRuleTriggerType =
      zio.aws.chime.model.SipRuleTriggerType.wrap(impl.triggerType())
    override val triggerValue: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.triggerValue())
    override val disabled: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: NullableBoolean)
    override val targetApplications
        : List[zio.aws.chime.model.SipRuleTargetApplication.ReadOnly] = impl
      .targetApplications()
      .asScala
      .map { item =>
        zio.aws.chime.model.SipRuleTargetApplication.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateSipRuleRequest
  ): zio.aws.chime.model.CreateSipRuleRequest.ReadOnly = new Wrapper(impl)
}
