package zio.aws.chime.model
import zio.aws.chime.model.primitives.{EmailAddress, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateUserRequest(
    accountId: NonEmptyString,
    username: Optional[String] = Optional.Absent,
    email: Optional[EmailAddress] = Optional.Absent,
    userType: Optional[zio.aws.chime.model.UserType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateUserRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        email.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(userType.map(value => value.unwrap))(_.userType)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateUserRequest.ReadOnly =
    zio.aws.chime.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateUserRequest =
      zio.aws.chime.model.CreateUserRequest(
        accountId,
        username.map(value => value),
        email.map(value => value),
        userType.map(value => value)
      )
    def accountId: NonEmptyString
    def username: Optional[String]
    def email: Optional[EmailAddress]
    def userType: Optional[zio.aws.chime.model.UserType]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getEmail: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("email", email)
    def getUserType: ZIO[Any, AwsError, zio.aws.chime.model.UserType] =
      AwsError.unwrapOptionField("userType", userType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateUserRequest
  ) extends zio.aws.chime.model.CreateUserRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val email: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.chime.model.primitives.EmailAddress(value))
    override val userType: Optional[zio.aws.chime.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userType())
        .map(value => zio.aws.chime.model.UserType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateUserRequest
  ): zio.aws.chime.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
