package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateUserResponse(
    user: Optional[zio.aws.chime.model.User] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateUserResponse = {
    import CreateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateUserResponse.ReadOnly =
    zio.aws.chime.model.CreateUserResponse.wrap(buildAwsValue())
}
object CreateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateUserResponse = zio.aws.chime.model
      .CreateUserResponse(user.map(value => value.asEditable))
    def user: Optional[zio.aws.chime.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.chime.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateUserResponse
  ) extends zio.aws.chime.model.CreateUserResponse.ReadOnly {
    override val user: Optional[zio.aws.chime.model.User.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.chime.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateUserResponse
  ): zio.aws.chime.model.CreateUserResponse.ReadOnly = new Wrapper(impl)
}
