package zio.aws.chime.model
import zio.aws.chime.model.primitives.VoiceConnectorGroupName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVoiceConnectorGroupRequest(
    name: VoiceConnectorGroupName,
    voiceConnectorItems: Optional[
      Iterable[zio.aws.chime.model.VoiceConnectorItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupRequest = {
    import CreateVoiceConnectorGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupRequest
      .builder()
      .name(VoiceConnectorGroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        voiceConnectorItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voiceConnectorItems)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.CreateVoiceConnectorGroupRequest.ReadOnly =
    zio.aws.chime.model.CreateVoiceConnectorGroupRequest.wrap(buildAwsValue())
}
object CreateVoiceConnectorGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateVoiceConnectorGroupRequest =
      zio.aws.chime.model.CreateVoiceConnectorGroupRequest(
        name,
        voiceConnectorItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: VoiceConnectorGroupName
    def voiceConnectorItems
        : Optional[List[zio.aws.chime.model.VoiceConnectorItem.ReadOnly]]
    def getName: ZIO[Any, Nothing, VoiceConnectorGroupName] = ZIO.succeed(name)
    def getVoiceConnectorItems: ZIO[Any, AwsError, List[
      zio.aws.chime.model.VoiceConnectorItem.ReadOnly
    ]] = AwsError.unwrapOptionField("voiceConnectorItems", voiceConnectorItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupRequest
  ) extends zio.aws.chime.model.CreateVoiceConnectorGroupRequest.ReadOnly {
    override val name: VoiceConnectorGroupName =
      zio.aws.chime.model.primitives.VoiceConnectorGroupName(impl.name())
    override val voiceConnectorItems
        : Optional[List[zio.aws.chime.model.VoiceConnectorItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.VoiceConnectorItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupRequest
  ): zio.aws.chime.model.CreateVoiceConnectorGroupRequest.ReadOnly =
    new Wrapper(impl)
}
