package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVoiceConnectorGroupResponse(
    voiceConnectorGroup: Optional[zio.aws.chime.model.VoiceConnectorGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupResponse = {
    import CreateVoiceConnectorGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupResponse
      .builder()
      .optionallyWith(voiceConnectorGroup.map(value => value.buildAwsValue()))(
        _.voiceConnectorGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.CreateVoiceConnectorGroupResponse.ReadOnly =
    zio.aws.chime.model.CreateVoiceConnectorGroupResponse.wrap(buildAwsValue())
}
object CreateVoiceConnectorGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateVoiceConnectorGroupResponse =
      zio.aws.chime.model.CreateVoiceConnectorGroupResponse(
        voiceConnectorGroup.map(value => value.asEditable)
      )
    def voiceConnectorGroup
        : Optional[zio.aws.chime.model.VoiceConnectorGroup.ReadOnly]
    def getVoiceConnectorGroup
        : ZIO[Any, AwsError, zio.aws.chime.model.VoiceConnectorGroup.ReadOnly] =
      AwsError.unwrapOptionField("voiceConnectorGroup", voiceConnectorGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupResponse
  ) extends zio.aws.chime.model.CreateVoiceConnectorGroupResponse.ReadOnly {
    override val voiceConnectorGroup
        : Optional[zio.aws.chime.model.VoiceConnectorGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorGroup())
        .map(value => zio.aws.chime.model.VoiceConnectorGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateVoiceConnectorGroupResponse
  ): zio.aws.chime.model.CreateVoiceConnectorGroupResponse.ReadOnly =
    new Wrapper(impl)
}
