package zio.aws.chime.model
import zio.aws.chime.model.primitives.VoiceConnectorName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVoiceConnectorRequest(
    name: VoiceConnectorName,
    awsRegion: Optional[zio.aws.chime.model.VoiceConnectorAwsRegion] =
      Optional.Absent,
    requireEncryption: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateVoiceConnectorRequest = {
    import CreateVoiceConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateVoiceConnectorRequest
      .builder()
      .name(VoiceConnectorName.unwrap(name): java.lang.String)
      .optionallyWith(awsRegion.map(value => value.unwrap))(_.awsRegion)
      .requireEncryption(requireEncryption: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateVoiceConnectorRequest.ReadOnly =
    zio.aws.chime.model.CreateVoiceConnectorRequest.wrap(buildAwsValue())
}
object CreateVoiceConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateVoiceConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateVoiceConnectorRequest =
      zio.aws.chime.model.CreateVoiceConnectorRequest(
        name,
        awsRegion.map(value => value),
        requireEncryption
      )
    def name: VoiceConnectorName
    def awsRegion: Optional[zio.aws.chime.model.VoiceConnectorAwsRegion]
    def requireEncryption: Boolean
    def getName: ZIO[Any, Nothing, VoiceConnectorName] = ZIO.succeed(name)
    def getAwsRegion
        : ZIO[Any, AwsError, zio.aws.chime.model.VoiceConnectorAwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getRequireEncryption: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(requireEncryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateVoiceConnectorRequest
  ) extends zio.aws.chime.model.CreateVoiceConnectorRequest.ReadOnly {
    override val name: VoiceConnectorName =
      zio.aws.chime.model.primitives.VoiceConnectorName(impl.name())
    override val awsRegion
        : Optional[zio.aws.chime.model.VoiceConnectorAwsRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsRegion())
        .map(value => zio.aws.chime.model.VoiceConnectorAwsRegion.wrap(value))
    override val requireEncryption: Boolean = impl.requireEncryption(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateVoiceConnectorRequest
  ): zio.aws.chime.model.CreateVoiceConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
