package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVoiceConnectorResponse(
    voiceConnector: Optional[zio.aws.chime.model.VoiceConnector] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateVoiceConnectorResponse = {
    import CreateVoiceConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateVoiceConnectorResponse
      .builder()
      .optionallyWith(voiceConnector.map(value => value.buildAwsValue()))(
        _.voiceConnector
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateVoiceConnectorResponse.ReadOnly =
    zio.aws.chime.model.CreateVoiceConnectorResponse.wrap(buildAwsValue())
}
object CreateVoiceConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateVoiceConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateVoiceConnectorResponse =
      zio.aws.chime.model.CreateVoiceConnectorResponse(
        voiceConnector.map(value => value.asEditable)
      )
    def voiceConnector: Optional[zio.aws.chime.model.VoiceConnector.ReadOnly]
    def getVoiceConnector
        : ZIO[Any, AwsError, zio.aws.chime.model.VoiceConnector.ReadOnly] =
      AwsError.unwrapOptionField("voiceConnector", voiceConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateVoiceConnectorResponse
  ) extends zio.aws.chime.model.CreateVoiceConnectorResponse.ReadOnly {
    override val voiceConnector
        : Optional[zio.aws.chime.model.VoiceConnector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnector())
        .map(value => zio.aws.chime.model.VoiceConnector.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateVoiceConnectorResponse
  ): zio.aws.chime.model.CreateVoiceConnectorResponse.ReadOnly = new Wrapper(
    impl
  )
}
