package zio.aws.chime.model
import zio.aws.chime.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Credential(
    username: Optional[SensitiveString] = Optional.Absent,
    password: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.Credential = {
    import Credential.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Credential
      .builder()
      .optionallyWith(
        username.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        password.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.password)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Credential.ReadOnly =
    zio.aws.chime.model.Credential.wrap(buildAwsValue())
}
object Credential {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Credential] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Credential = zio.aws.chime.model
      .Credential(username.map(value => value), password.map(value => value))
    def username: Optional[SensitiveString]
    def password: Optional[SensitiveString]
    def getUsername: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("password", password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Credential
  ) extends zio.aws.chime.model.Credential.ReadOnly {
    override val username: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val password: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Credential
  ): zio.aws.chime.model.Credential.ReadOnly = new Wrapper(impl)
}
