package zio.aws.chime.model
import zio.aws.chime.model.primitives.{Alpha2CountryCode, E164PhoneNumber}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DNISEmergencyCallingConfiguration(
    emergencyPhoneNumber: E164PhoneNumber,
    testPhoneNumber: Optional[E164PhoneNumber] = Optional.Absent,
    callingCountry: Alpha2CountryCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DNISEmergencyCallingConfiguration = {
    import DNISEmergencyCallingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DNISEmergencyCallingConfiguration
      .builder()
      .emergencyPhoneNumber(
        E164PhoneNumber.unwrap(emergencyPhoneNumber): java.lang.String
      )
      .optionallyWith(
        testPhoneNumber.map(value =>
          E164PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.testPhoneNumber)
      .callingCountry(
        Alpha2CountryCode.unwrap(callingCountry): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DNISEmergencyCallingConfiguration.ReadOnly =
    zio.aws.chime.model.DNISEmergencyCallingConfiguration.wrap(buildAwsValue())
}
object DNISEmergencyCallingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DNISEmergencyCallingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DNISEmergencyCallingConfiguration =
      zio.aws.chime.model.DNISEmergencyCallingConfiguration(
        emergencyPhoneNumber,
        testPhoneNumber.map(value => value),
        callingCountry
      )
    def emergencyPhoneNumber: E164PhoneNumber
    def testPhoneNumber: Optional[E164PhoneNumber]
    def callingCountry: Alpha2CountryCode
    def getEmergencyPhoneNumber: ZIO[Any, Nothing, E164PhoneNumber] =
      ZIO.succeed(emergencyPhoneNumber)
    def getTestPhoneNumber: ZIO[Any, AwsError, E164PhoneNumber] =
      AwsError.unwrapOptionField("testPhoneNumber", testPhoneNumber)
    def getCallingCountry: ZIO[Any, Nothing, Alpha2CountryCode] =
      ZIO.succeed(callingCountry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DNISEmergencyCallingConfiguration
  ) extends zio.aws.chime.model.DNISEmergencyCallingConfiguration.ReadOnly {
    override val emergencyPhoneNumber: E164PhoneNumber =
      zio.aws.chime.model.primitives
        .E164PhoneNumber(impl.emergencyPhoneNumber())
    override val testPhoneNumber: Optional[E164PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testPhoneNumber())
        .map(value => zio.aws.chime.model.primitives.E164PhoneNumber(value))
    override val callingCountry: Alpha2CountryCode =
      zio.aws.chime.model.primitives.Alpha2CountryCode(impl.callingCountry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DNISEmergencyCallingConfiguration
  ): zio.aws.chime.model.DNISEmergencyCallingConfiguration.ReadOnly =
    new Wrapper(impl)
}
