package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAccountRequest(accountId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteAccountRequest = {
    import DeleteAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteAccountRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteAccountRequest.ReadOnly =
    zio.aws.chime.model.DeleteAccountRequest.wrap(buildAwsValue())
}
object DeleteAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteAccountRequest =
      zio.aws.chime.model.DeleteAccountRequest(accountId)
    def accountId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteAccountRequest
  ) extends zio.aws.chime.model.DeleteAccountRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteAccountRequest
  ): zio.aws.chime.model.DeleteAccountRequest.ReadOnly = new Wrapper(impl)
}
