package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAppInstanceAdminRequest(
    appInstanceAdminArn: ChimeArn,
    appInstanceArn: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteAppInstanceAdminRequest = {
    import DeleteAppInstanceAdminRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteAppInstanceAdminRequest
      .builder()
      .appInstanceAdminArn(
        ChimeArn.unwrap(appInstanceAdminArn): java.lang.String
      )
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteAppInstanceAdminRequest.ReadOnly =
    zio.aws.chime.model.DeleteAppInstanceAdminRequest.wrap(buildAwsValue())
}
object DeleteAppInstanceAdminRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteAppInstanceAdminRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteAppInstanceAdminRequest =
      zio.aws.chime.model
        .DeleteAppInstanceAdminRequest(appInstanceAdminArn, appInstanceArn)
    def appInstanceAdminArn: ChimeArn
    def appInstanceArn: ChimeArn
    def getAppInstanceAdminArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceAdminArn)
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteAppInstanceAdminRequest
  ) extends zio.aws.chime.model.DeleteAppInstanceAdminRequest.ReadOnly {
    override val appInstanceAdminArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceAdminArn())
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteAppInstanceAdminRequest
  ): zio.aws.chime.model.DeleteAppInstanceAdminRequest.ReadOnly = new Wrapper(
    impl
  )
}
