package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAppInstanceStreamingConfigurationsRequest(
    appInstanceArn: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteAppInstanceStreamingConfigurationsRequest = {
    import DeleteAppInstanceStreamingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteAppInstanceStreamingConfigurationsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteAppInstanceStreamingConfigurationsRequest.ReadOnly =
    zio.aws.chime.model.DeleteAppInstanceStreamingConfigurationsRequest
      .wrap(buildAwsValue())
}
object DeleteAppInstanceStreamingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteAppInstanceStreamingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.DeleteAppInstanceStreamingConfigurationsRequest =
      zio.aws.chime.model
        .DeleteAppInstanceStreamingConfigurationsRequest(appInstanceArn)
    def appInstanceArn: ChimeArn
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteAppInstanceStreamingConfigurationsRequest
  ) extends zio.aws.chime.model.DeleteAppInstanceStreamingConfigurationsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteAppInstanceStreamingConfigurationsRequest
  ): zio.aws.chime.model.DeleteAppInstanceStreamingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
