package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAppInstanceUserRequest(appInstanceUserArn: ChimeArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteAppInstanceUserRequest = {
    import DeleteAppInstanceUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteAppInstanceUserRequest
      .builder()
      .appInstanceUserArn(ChimeArn.unwrap(appInstanceUserArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteAppInstanceUserRequest.ReadOnly =
    zio.aws.chime.model.DeleteAppInstanceUserRequest.wrap(buildAwsValue())
}
object DeleteAppInstanceUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteAppInstanceUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteAppInstanceUserRequest =
      zio.aws.chime.model.DeleteAppInstanceUserRequest(appInstanceUserArn)
    def appInstanceUserArn: ChimeArn
    def getAppInstanceUserArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceUserArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteAppInstanceUserRequest
  ) extends zio.aws.chime.model.DeleteAppInstanceUserRequest.ReadOnly {
    override val appInstanceUserArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceUserArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteAppInstanceUserRequest
  ): zio.aws.chime.model.DeleteAppInstanceUserRequest.ReadOnly = new Wrapper(
    impl
  )
}
