package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAttendeeRequest(
    meetingId: GuidString,
    attendeeId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteAttendeeRequest = {
    import DeleteAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .attendeeId(GuidString.unwrap(attendeeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteAttendeeRequest.ReadOnly =
    zio.aws.chime.model.DeleteAttendeeRequest.wrap(buildAwsValue())
}
object DeleteAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteAttendeeRequest =
      zio.aws.chime.model.DeleteAttendeeRequest(meetingId, attendeeId)
    def meetingId: GuidString
    def attendeeId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getAttendeeId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(attendeeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteAttendeeRequest
  ) extends zio.aws.chime.model.DeleteAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val attendeeId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.attendeeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteAttendeeRequest
  ): zio.aws.chime.model.DeleteAttendeeRequest.ReadOnly = new Wrapper(impl)
}
