package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteChannelMembershipRequest(
    channelArn: ChimeArn,
    memberArn: ChimeArn,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteChannelMembershipRequest = {
    import DeleteChannelMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteChannelMembershipRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .memberArn(ChimeArn.unwrap(memberArn): java.lang.String)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteChannelMembershipRequest.ReadOnly =
    zio.aws.chime.model.DeleteChannelMembershipRequest.wrap(buildAwsValue())
}
object DeleteChannelMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteChannelMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteChannelMembershipRequest =
      zio.aws.chime.model.DeleteChannelMembershipRequest(
        channelArn,
        memberArn,
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def memberArn: ChimeArn
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMemberArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(memberArn)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteChannelMembershipRequest
  ) extends zio.aws.chime.model.DeleteChannelMembershipRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val memberArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.memberArn())
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteChannelMembershipRequest
  ): zio.aws.chime.model.DeleteChannelMembershipRequest.ReadOnly = new Wrapper(
    impl
  )
}
