package zio.aws.chime.model
import zio.aws.chime.model.primitives.{MessageId, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteChannelMessageRequest(
    channelArn: ChimeArn,
    messageId: MessageId,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteChannelMessageRequest = {
    import DeleteChannelMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteChannelMessageRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteChannelMessageRequest.ReadOnly =
    zio.aws.chime.model.DeleteChannelMessageRequest.wrap(buildAwsValue())
}
object DeleteChannelMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteChannelMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteChannelMessageRequest =
      zio.aws.chime.model.DeleteChannelMessageRequest(
        channelArn,
        messageId,
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def messageId: MessageId
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteChannelMessageRequest
  ) extends zio.aws.chime.model.DeleteChannelMessageRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val messageId: MessageId =
      zio.aws.chime.model.primitives.MessageId(impl.messageId())
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteChannelMessageRequest
  ): zio.aws.chime.model.DeleteChannelMessageRequest.ReadOnly = new Wrapper(
    impl
  )
}
