package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteChannelRequest(
    channelArn: ChimeArn,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteChannelRequest = {
    import DeleteChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteChannelRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteChannelRequest.ReadOnly =
    zio.aws.chime.model.DeleteChannelRequest.wrap(buildAwsValue())
}
object DeleteChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteChannelRequest =
      zio.aws.chime.model
        .DeleteChannelRequest(channelArn, chimeBearer.map(value => value))
    def channelArn: ChimeArn
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteChannelRequest
  ) extends zio.aws.chime.model.DeleteChannelRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteChannelRequest
  ): zio.aws.chime.model.DeleteChannelRequest.ReadOnly = new Wrapper(impl)
}
