package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEventsConfigurationRequest(
    accountId: NonEmptyString,
    botId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationRequest = {
    import DeleteEventsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .botId(NonEmptyString.unwrap(botId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteEventsConfigurationRequest.ReadOnly =
    zio.aws.chime.model.DeleteEventsConfigurationRequest.wrap(buildAwsValue())
}
object DeleteEventsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteEventsConfigurationRequest =
      zio.aws.chime.model.DeleteEventsConfigurationRequest(accountId, botId)
    def accountId: NonEmptyString
    def botId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getBotId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(botId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationRequest
  ) extends zio.aws.chime.model.DeleteEventsConfigurationRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val botId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.botId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteEventsConfigurationRequest
  ): zio.aws.chime.model.DeleteEventsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
