package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMediaCapturePipelineRequest(
    mediaPipelineId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteMediaCapturePipelineRequest = {
    import DeleteMediaCapturePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteMediaCapturePipelineRequest
      .builder()
      .mediaPipelineId(GuidString.unwrap(mediaPipelineId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteMediaCapturePipelineRequest.ReadOnly =
    zio.aws.chime.model.DeleteMediaCapturePipelineRequest.wrap(buildAwsValue())
}
object DeleteMediaCapturePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteMediaCapturePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteMediaCapturePipelineRequest =
      zio.aws.chime.model.DeleteMediaCapturePipelineRequest(mediaPipelineId)
    def mediaPipelineId: GuidString
    def getMediaPipelineId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(mediaPipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteMediaCapturePipelineRequest
  ) extends zio.aws.chime.model.DeleteMediaCapturePipelineRequest.ReadOnly {
    override val mediaPipelineId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.mediaPipelineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteMediaCapturePipelineRequest
  ): zio.aws.chime.model.DeleteMediaCapturePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
