package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMeetingRequest(meetingId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteMeetingRequest = {
    import DeleteMeetingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteMeetingRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteMeetingRequest.ReadOnly =
    zio.aws.chime.model.DeleteMeetingRequest.wrap(buildAwsValue())
}
object DeleteMeetingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteMeetingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteMeetingRequest =
      zio.aws.chime.model.DeleteMeetingRequest(meetingId)
    def meetingId: GuidString
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteMeetingRequest
  ) extends zio.aws.chime.model.DeleteMeetingRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteMeetingRequest
  ): zio.aws.chime.model.DeleteMeetingRequest.ReadOnly = new Wrapper(impl)
}
