package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePhoneNumberRequest(phoneNumberId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeletePhoneNumberRequest = {
    import DeletePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeletePhoneNumberRequest
      .builder()
      .phoneNumberId(phoneNumberId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeletePhoneNumberRequest.ReadOnly =
    zio.aws.chime.model.DeletePhoneNumberRequest.wrap(buildAwsValue())
}
object DeletePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeletePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeletePhoneNumberRequest =
      zio.aws.chime.model.DeletePhoneNumberRequest(phoneNumberId)
    def phoneNumberId: String
    def getPhoneNumberId: ZIO[Any, Nothing, String] = ZIO.succeed(phoneNumberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeletePhoneNumberRequest
  ) extends zio.aws.chime.model.DeletePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: String = impl.phoneNumberId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeletePhoneNumberRequest
  ): zio.aws.chime.model.DeletePhoneNumberRequest.ReadOnly = new Wrapper(impl)
}
