package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteRoomRequest(
    accountId: NonEmptyString,
    roomId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteRoomRequest = {
    import DeleteRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteRoomRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .roomId(NonEmptyString.unwrap(roomId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.DeleteRoomRequest.ReadOnly =
    zio.aws.chime.model.DeleteRoomRequest.wrap(buildAwsValue())
}
object DeleteRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteRoomRequest =
      zio.aws.chime.model.DeleteRoomRequest(accountId, roomId)
    def accountId: NonEmptyString
    def roomId: NonEmptyString
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getRoomId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(roomId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteRoomRequest
  ) extends zio.aws.chime.model.DeleteRoomRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val roomId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.roomId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteRoomRequest
  ): zio.aws.chime.model.DeleteRoomRequest.ReadOnly = new Wrapper(impl)
}
