package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSipMediaApplicationRequest(
    sipMediaApplicationId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.DeleteSipMediaApplicationRequest = {
    import DeleteSipMediaApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.DeleteSipMediaApplicationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.DeleteSipMediaApplicationRequest.ReadOnly =
    zio.aws.chime.model.DeleteSipMediaApplicationRequest.wrap(buildAwsValue())
}
object DeleteSipMediaApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.DeleteSipMediaApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.DeleteSipMediaApplicationRequest =
      zio.aws.chime.model
        .DeleteSipMediaApplicationRequest(sipMediaApplicationId)
    def sipMediaApplicationId: NonEmptyString
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.DeleteSipMediaApplicationRequest
  ) extends zio.aws.chime.model.DeleteSipMediaApplicationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.DeleteSipMediaApplicationRequest
  ): zio.aws.chime.model.DeleteSipMediaApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
